<?php
defined('BASEPATH') or exit('No direct script access allowed');


class Orders extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->library(['razorpay', 'stripe', 'paystack', 'flutterwave']);
        $this->load->helper(['url', 'language', 'timezone_helper']);
        $this->load->model('Order_model');
        $this->data['firebase_project_id'] = get_settings('firebase_project_id');
        $this->data['service_account_file'] = get_settings('service_account_file');

        if (!has_permissions('read', 'orders')) {
            $this->session->set_flashdata('authorize_flag', PERMISSION_ERROR_MSG);
            redirect('admin/home', 'refresh');
        } else {
            $this->session->set_flashdata('authorize_flag', "");
        }
    }

    public function index()
    {
        if ($this->ion_auth->logged_in() && $this->ion_auth->is_admin()) {
            $this->data['main_page'] = TABLES . 'manage-orders';
            $settings = get_settings('system_settings', true);
            $this->data['title'] = 'Order Management | ' . $settings['app_name'];
            $this->data['meta_description'] = ' Order Management  | ' . $settings['app_name'];
            $this->data['about_us'] = get_settings('about_us');
            $this->data['curreny'] = get_settings('currency');
            $orders_count['awaiting'] = orders_count("awaiting");
            $orders_count['received'] = orders_count("received");
            $orders_count['processed'] = orders_count("processed");
            $orders_count['shipped'] = orders_count("shipped");
            $orders_count['delivered'] = orders_count("delivered");
            $orders_count['cancelled'] = orders_count("cancelled");
            $orders_count['returned'] = orders_count("returned");
            $this->data['status_counts'] = $orders_count;
            $this->data['delivery_res'] = $this->db->where(['ug.group_id' => '3'])->join('users_groups ug', 'ug.user_id = u.id')->get('users u')->result_array();
            if (isset($_GET['edit_id'])) {
                $order_item_data = fetch_details('order_items', ['id' => $_GET['edit_id']], 'order_id,product_name,user_id');
                $order_data = fetch_details('orders', ['id' => $order_item_data[0]['order_id']], 'email');
                $user_data = fetch_details('users', ['id' => $order_item_data[0]['user_id']], 'username');
                $this->data['fetched'] = $order_data;
                $this->data['order_item_data'] = $order_item_data;
                $this->data['user_data'] = $user_data[0];
            }
            $this->load->view('admin/template', $this->data);
        } else {

            redirect('admin/login', 'refresh');
        }
    }

    public function view_orders()
    {
        if ($this->ion_auth->logged_in() && $this->ion_auth->is_admin()) {
            return $this->Order_model->get_orders_list();
        } else {
            redirect('admin/login', 'refresh');
        }
    }
    public function get_digital_order_mails()
    {
        if ($this->ion_auth->logged_in() && $this->ion_auth->is_admin()) {
            return $this->Order_model->get_digital_order_mail_list();
        } else {
            redirect('admin/login', 'refresh');
        }
    }

    public function view_order_items()
    {
        if ($this->ion_auth->logged_in() && $this->ion_auth->is_admin()) {
            return $this->Order_model->get_order_items_list();
        } else {
            redirect('admin/login', 'refresh');
        }
    }

    public function view_digital_product_orders()
    {
        if ($this->ion_auth->logged_in() && $this->ion_auth->is_admin()) {
            return $this->Order_model->get_digital_product_orders_list();
        } else {
            redirect('admin/login', 'refresh');
        }
    }

    public function view_digital_product_order_items()
    {
        if ($this->ion_auth->logged_in() && $this->ion_auth->is_admin()) {
            return $this->Order_model->get_digital_product_order_items_list();
        } else {
            redirect('admin/login', 'refresh');
        }
    }

    public function send_digital_product()
    {
        if ($this->ion_auth->logged_in() && $this->ion_auth->is_admin()) {
            $this->form_validation->set_rules('message', 'Message', 'trim|required|xss_clean');

            if (!$this->form_validation->run()) {
                $this->response['error'] = true;
                $this->response['message'] = strip_tags(validation_errors());
                $this->response['data'] = array();
                $this->response['csrfName'] = $this->security->get_csrf_token_name();
                $this->response['csrfHash'] = $this->security->get_csrf_hash();
                print_r(json_encode($this->response));
                return false;
            }
            $mail = $this->Order_model->send_digital_product($_POST);
            if ($mail['error'] == true) {
                $this->response['error'] = true;
                $this->response['message'] = "Cannot send mail. You can try to send mail manually.";
                $this->response['data'] = $mail['message'];
                echo json_encode($this->response);
                return false;
            } else {
                $this->response['error'] = false;
                $this->response['message'] = 'Mail sent successfully.';
                $this->response['data'] = array();
                echo json_encode($this->response);
                update_details(['active_status' => 'delivered'], ['id' => $_POST['order_item_id']], 'order_items');
                update_details(['is_sent' => 1], ['id' => $_POST['order_item_id']], 'order_items');
                $data = array(
                    'order_id' => $_POST['order_id'],
                    'order_item_id' => $_POST['order_item_id'],
                    'subject' => $_POST['subject'],
                    'message' => $_POST['message'],
                    'file_url' => $_POST['pro_input_file'],
                );
                insert_details($data, 'digital_orders_mails');
                return false;
            }
        } else {
            redirect('admin/login', 'refresh');
        }
    }



    function digital_product_orders()
    {
        if ($this->ion_auth->logged_in() && $this->ion_auth->is_admin()) {
            $this->data['main_page'] = TABLES . 'manage-digital-product-order';
            $settings = get_settings('system_settings', true);
            $this->data['title'] = 'Order Management | ' . $settings['app_name'];
            $this->data['meta_description'] = ' Order Management  | ' . $settings['app_name'];
            $this->data['about_us'] = get_settings('about_us');
            $this->data['curreny'] = get_settings('currency');
            if (isset($_GET['edit_id'])) {
                $order_data = fetch_details('orders', ['id' => $_GET['edit_id']], 'email');
                $order_item_data = fetch_details('order_items', ['order_id' => $_GET['edit_id']], 'id,product_name');
                $this->data['fetched'] = $order_data;
                $this->data['order_item_data'] = $order_item_data;
            }

            $this->load->view('admin/template', $this->data);
        } else {
            redirect('admin/login', 'refresh');
        }
    }
    public function delete_orders()
    {
        if ($this->ion_auth->logged_in() && $this->ion_auth->is_admin()) {
            if (print_msg(!has_permissions('delete', 'orders'), PERMISSION_ERROR_MSG, 'orders')) {
                return false;
            }
            if (delete_details(['id' => $_GET['id']], 'orders')) {
                delete_details(['order_id' => $_GET['id']], 'order_items');
                $response['error'] = false;
                $response['message'] = 'Deleted Successfully';
                $response['permission'] = !has_permissions('delete', 'orders');
            } else {
                $response['error'] = true;
                $response['message'] = 'Something went wrong';
            }
            echo json_encode($response);
        } else {
            redirect('admin/login', 'refresh');
        }
    }

    /* Update complete order status */
    public function update_orders()
    {
        if ($this->ion_auth->logged_in() && $this->ion_auth->is_admin()) {
            if (print_msg(!has_permissions('update', 'orders'), PERMISSION_ERROR_MSG, 'orders')) {
                return false;
            }

            $order_method = fetch_details('orders', ['id' => $this->input->post('orderid', true)], 'payment_method,is_local_pickup');
            if ($order_method[0]['payment_method'] == 'bank_transfer') {
                $bank_receipt = fetch_details('order_bank_transfer', ['order_id' => $this->input->post('orderid', true)]);
                $transaction_status = fetch_details('transactions', ['order_id' => $this->input->post('orderid', true)], 'status');
                if ($this->input->post('val', true) != 'cancelled' && (empty($bank_receipt) || strtolower($transaction_status[0]['status']) != 'success' || $bank_receipt[0]['status'] == "0" || $bank_receipt[0]['status'] == "1")) {
                    $this->response['error'] = true;
                    $this->response['message'] = "Order Status can not update, Bank verification is remain from transactions.";
                    $this->response['csrfName'] = $this->security->get_csrf_token_name();
                    $this->response['csrfHash'] = $this->security->get_csrf_hash();
                    $this->response['data'] = array();
                    print_r(json_encode($this->response));
                    return false;
                }
            }

            $pickup_time = $this->input->post('pickup_time', true);
            $seller_notes = $this->input->post('seller_notes', true);

            if ((isset($pickup_time) || isset($seller_notes)) && ($pickup_time != 'undefined' || $seller_notes != 'undefined') && ($pickup_time != '' || $seller_notes != '')) {
                $data = array(
                    'pickup_time' => $this->input->post('pickup_time', true),
                    'seller_notes' => $this->input->post('seller_notes', true),
                );
                update_details($data, ['id' => $this->input->post('orderid', true)], 'orders');
            }

            $msg = '';

            $deliver_by = $this->input->post('deliver_by', true);
            $orderid = $this->input->post('orderid', true);

            if (isset($deliver_by) && !empty($deliver_by) && isset($orderid) && !empty($orderid)) {
                $where = "id = " . $this->input->post('orderid', true) . "";
                $current_delivery_boy = fetch_details('orders', $where, 'delivery_boy_id');
                $settings = get_settings('system_settings', true);
                $app_name = isset($settings['app_name']) && !empty($settings['app_name']) ? $settings['app_name'] : '';
                $user_res = fetch_details('users', ['id' => $this->input->post('deliver_by', true)], 'fcm_id,username,mobile,email', 'web_fcm');
                $fcm_ids = array();
                $web_fcm = array();

                if (isset($user_res[0]) && !empty($user_res[0])) {
                    if (isset($current_delivery_boy[0]['delivery_boy_id']) && $current_delivery_boy[0]['delivery_boy_id'] == $this->input->post('deliver_by', true)) {
                        if ($this->input->post('val', true) == 'received') {
                            $type = ['type' => "customer_order_received"];
                        } elseif ($this->input->post('val', true) == 'processed') {
                            $type = ['type' => "customer_order_processed"];
                        } elseif ($this->input->post('val', true) == 'shipped') {
                            $type = ['type' => "customer_order_shipped"];
                        } elseif ($this->input->post('val', true) == 'delivered') {
                            $type = ['type' => "customer_order_delivered"];
                        } elseif ($this->input->post('val', true) == 'cancelled') {
                            $type = ['type' => "customer_order_cancelled"];
                        } elseif ($this->input->post('val', true) == 'returned') {
                            $type = ['type' => "customer_order_returned"];
                        }

                        $custom_notification = fetch_details('custom_notifications', $type, '');

                        $hashtag_cutomer_name = '< cutomer_name >';
                        $hashtag_order_id = '< order_id >';
                        $hashtag_application_name = '< application_name >';

                        $string = json_encode($custom_notification[0]['message'], JSON_UNESCAPED_UNICODE);
                        $hashtag = html_entity_decode($string);

                        $data = str_replace(array($hashtag_cutomer_name, $hashtag_order_id, $hashtag_application_name), array($user_res[0]['username'], $this->input->post('orderid', true), $app_name), $hashtag);
                        $message = output_escaping(trim($data, '"'));

                        $customer_msg = (!empty($custom_notification)) ? $message : 'Hello Dear ' . $user_res[0]['username'] . ' order status updated to ' . $this->input->post('val', true) . ' for order ID #' . $$this->input->post('orderid', true) . ' assigned to you please take note of it! Thank you. Regards ' . $app_name . '';

                        $fcmMsg = array(
                            'title' => (!empty($custom_notification)) ? $custom_notification[0]['title'] : "Order status updated",
                            'body' => $customer_msg,
                            'type' => "order"
                        );
                        notify_event(
                            $type['type'],
                            ["delivery_boy" => [$user_res[0]['email']]],
                            ["delivery_boy" => [$user_res[0]['mobile']]],
                            ["orders.id" => $this->input->post('orderid', true)]
                        );
                        notify_event(
                            $type['type'],
                            ["customer" => [$user_res[0]['email']]],
                            ["customer" => [$user_res[0]['mobile']]],
                            ["orders.id" => $this->input->post('orderid', true)]
                        );
                    } else {
                        $custom_notification = fetch_details('custom_notifications', ['type' => "delivery_boy_order_deliver"], '');

                        $hashtag_cutomer_name = '< cutomer_name >';
                        $hashtag_order_id = '< order_id >';
                        $hashtag_application_name = '< application_name >';

                        $string = json_encode($custom_notification[0]['message'], JSON_UNESCAPED_UNICODE);
                        $hashtag = html_entity_decode($string);

                        $data = str_replace(array($hashtag_cutomer_name, $hashtag_order_id, $hashtag_application_name), array($user_res[0]['username'], $this->input->post('orderid', true), $app_name), $hashtag);
                        $message = output_escaping(trim($data, '"'));

                        $customer_msg = (!empty($custom_notification)) ? $message : 'Hello Dear ' . $user_res[0]['username'] . ' you have new order to be deliver order ID #' . $this->input->post('orderid', true) . ' please take note of it! Thank you. Regards ' . $app_name . '';

                        $fcmMsg = array(
                            'title' => (!empty($custom_notification)) ? $custom_notification[0]['title'] : "You have new order to deliver",
                            'body' => $customer_msg,
                            'type' => "order"
                        );
                        $msg = 'Delivery Boy Updated. ';
                        notify_event(
                            "delivery_boy_order_deliver",
                            ["delivery_boy" => [$user_res[0]['email']]],
                            ["delivery_boy" => [$user_res[0]['mobile']]],
                            ["orders.id" => $this->input->post('orderid', true)]
                        );
                    }
                }
                if (!empty($user_res[0]['fcm_id'])) {
                    $fcm_ids[0][] = $user_res[0]['fcm_id'];
                    send_notification($fcmMsg, $fcm_ids, $fcmMsg);
                }


                $where = [
                    'id' => $this->input->post('orderid', true)
                ];


                if ($this->Order_model->update_order(['delivery_boy_id' => $this->input->post('deliver_by', true)], $where)) {
                    $delivery_error = false;
                }
                if (!empty($user_res[0]['web_fcm'])) {
                    $web_fcm[0][] = $user_res[0]['web_fcm'];
                    send_notification_for_web($fcmMsg, $web_fcm, $fcmMsg);
                }
            }

            $res = validate_order_status($this->input->post('orderid', true), $this->input->post('val', true), 'orders');
            if ($res['error']) {
                $this->response['error'] = true;
                $this->response['message'] = $msg . $res['message'];
                $this->response['csrfName'] = $this->security->get_csrf_token_name();
                $this->response['csrfHash'] = $this->security->get_csrf_hash();
                $this->response['data'] = array();
                print_r(json_encode($this->response));
                return false;
            }

            $settings = get_settings('system_settings', true);
            $local_pickup = isset($settings['local_pickup']) && ($settings['local_pickup'] != '') ? $settings['local_pickup'] : '0';
            $pickup_status = ($local_pickup == 1 && $order_method[0]['is_local_pickup'] == 1) ? 'ready_to_pickup' : 'shipped';

            $priority_status = [
                'received' => 0,
                'processed' => 1,
                $pickup_status => 2,
                'delivered' => 3,
                'cancelled' => 4,
                'returned' => 5,
            ];

            $update_status = 1;
            $error = TRUE;
            $message = '';

            $where_id = "id = " . $this->input->post('orderid', true) . " and (active_status != 'cancelled' and active_status != 'returned' ) ";
            $where_order_id = "order_id = " . $this->input->post('orderid', true) . " and (active_status != 'cancelled' and active_status != 'returned' ) ";

            $order_items_details = fetch_details('order_items', $where_order_id, 'active_status');
            $counter = count($order_items_details);
            $cancel_counter = 0;
            foreach ($order_items_details as $row) {
                if ($row['active_status'] == 'cancelled') {
                    ++$cancel_counter;
                }
            }
            if ($cancel_counter == $counter) {
                $update_status = 0;
            }

            $orderid = $this->input->post('orderid', true);
            $field = $this->input->post('field', true);
            $val = $this->input->post('val', true);



            if (isset($orderid) && isset($field) && isset($val)) {
                if ($this->input->post('field', true) == 'status' && $update_status == 1) {

                    $current_orders_status = fetch_details('orders', $where_id, 'user_id,active_status');
                    $user_id = $current_orders_status[0]['user_id'];
                    $user_res = fetch_details('users', ['id' => $user_id], 'username,fcm_id,mobile,email,web_fcm');


                    $current_orders_status = $current_orders_status[0]['active_status'];

                    if ($priority_status[$this->input->post('val', true)] > $priority_status[$current_orders_status]) {


                        $set = [
                            $this->input->post('field', true) => $this->input->post('val', true) // status => 'proceesed'
                        ];

                        // Update Active Status of Order Table										
                        if ($this->Order_model->update_order($set, $where_id, $this->input->post('json', true))) {
                            if ($this->Order_model->update_order(['active_status' => $this->input->post('val', true)], $where_id)) {
                                if ($this->Order_model->update_order($set, $where_order_id, $this->input->post('json', true), 'order_items')) {
                                    if ($this->Order_model->update_order(['active_status' => $this->input->post('val', true)], $where_order_id, false, 'order_items')) {
                                        $error = false;
                                    }
                                }
                            }
                        }

                        if ($error == false) {


                            /* Send custom notification message*/

                            $settings = get_settings('system_settings', true);
                            $app_name = isset($settings['app_name']) && !empty($settings['app_name']) ? $settings['app_name'] : '';

                            if ($this->input->post('val', true) == 'received') {
                                $type = ['type' => "customer_order_received"];
                            } elseif ($this->input->post('val', true) == 'processed') {
                                $type = ['type' => "customer_order_processed"];
                            } elseif ($this->input->post('val', true) == 'ready_to_pickup') {
                                $type = ['type' => "customer_order_processed"];
                            } elseif ($this->input->post('val', true) == 'shipped') {
                                $type = ['type' => "customer_order_shipped"];
                            } elseif ($this->input->post('val', true) == 'delivered') {
                                $type = ['type' => "customer_order_delivered"];
                            } elseif ($this->input->post('val', true) == 'cancelled') {
                                $type = ['type' => "customer_order_cancelled"];
                            } elseif ($this->input->post('val', true) == 'returned') {
                                $type = ['type' => "customer_order_returned"];
                            }
                            $firebase_project_id_details = fetch_details('settings', ['variable' => 'firebase_project_id']);
                            $service_account_file = fetch_details('settings', ['variable' => 'service_account_file']);
                            $vap_id_Key = fetch_details('settings', ['variable' => 'vap_id_Key']);
                            $custom_notification = fetch_details('custom_notifications', $type, '');

                            $hashtag_cutomer_name = '< cutomer_name >';
                            $hashtag_order_id = '< order_id >';
                            $hashtag_application_name = '< application_name >';

                            $string = json_encode($custom_notification[0]['message'], JSON_UNESCAPED_UNICODE);
                            $hashtag = html_entity_decode($string);

                            $data = str_replace(array($hashtag_cutomer_name, $hashtag_order_id, $hashtag_application_name), array($user_res[0]['username'], $this->input->post('orderid', true), $app_name), $hashtag);
                            $message = output_escaping(trim($data, '"'));

                            $customer_msg = (!empty($custom_notification)) ? str_replace('\r\n', ' ', output_escaping($message)) : 'Hello Dear ' . $user_res[0]['username'] . ' order status updated to ' . $this->input->post('val', true) . ' for your order ID #' . $this->input->post('orderid', true) . ' please take note of it! Thank you for shopping with us. Regards ' . $app_name . '';


                            $fcm_ids = array();
                            $web_fcm = array();


                            $firebase_project_id = $this->data['firebase_project_id'];
                            $service_account_file = $this->data['service_account_file'];


                            if (!empty($user_res[0]['fcm_id']) && isset($firebase_project_id) && isset($service_account_file) && !empty($firebase_project_id) && !empty($service_account_file)) {

                                $fcmMsg = array(
                                    'title' => (!empty($custom_notification)) ? $custom_notification[0]['title'] : "Order status updated",
                                    'body' => $customer_msg,
                                    'type' => "order"
                                );

                                if (!empty($user_res[0]['fcm_id'])) {
                                    $fcm_ids[0][] = $user_res[0]['fcm_id'];
                                }

                                if (!empty($user_res[0]['web_fcm'])) {
                                    $web_fcm[0][] = $user_res[0]['web_fcm'];
                                }

                                if (!empty($fcm_ids)) {
                                    send_notification($fcmMsg, $fcm_ids, $fcmMsg);
                                }

                                if (!empty($web_fcm)) {
                                    send_notification_for_web($fcmMsg, $web_fcm, $fcmMsg);
                                }
                            }

                            notify_event(
                                $type['type'],
                                ["customer" => [$user_res[0]['email']]],
                                ["customer" => [$user_res[0]['mobile']]],
                                ["orders.id" => $this->input->post('orderid', true)]
                            );
                            /* Process refer and earn bonus */
                            process_refund($this->input->post('orderid', true), $this->input->post('val', true), 'orders');
                            if (trim($this->input->post('val', true) == 'cancelled')) {
                                $data = fetch_details('order_items', ['order_id' => $this->input->post('orderid', true)], 'product_variant_id,quantity');
                                $product_variant_ids = [];
                                $qtns = [];
                                foreach ($data as $d) {
                                    array_push($product_variant_ids, $d['product_variant_id']);
                                    array_push($qtns, $d['quantity']);
                                }

                                update_stock($product_variant_ids, $qtns, 'plus');
                            }
                            $response = process_referral_bonus($user_id, $this->input->post('orderid', true), $this->input->post('val', true));
                            $message = 'Status Updated Successfully';

                            update_details(['updated_by' => $_SESSION['user_id']], ['order_id' => $this->input->post('orderid', true)], 'order_items');
                            if ($this->input->post('val', true) == 'cancelled' || $this->input->post('val', true) == 'returned') {
                                $admin_notifi = array(
                                    'title' => ($this->input->post('val', true) == 'cancelled') ? "Order Cancelled" : "Order Returned",
                                    'message' => "Order ID: " . $this->input->post('orderid', true) . " has been " . $this->input->post('val', true) . ".",
                                    'type' => ($this->input->post('val', true) == 'cancelled') ? "order_cancelled" : "order_returned",
                                    'type_id' => $this->input->post('orderid', true)
                                );

                                insert_details($admin_notifi, 'system_notification');
                            }
                        }
                    }
                }
                if ($error == true) {
                    $message = $msg . ' Order is already marked as cancelled. You cannot set it again !';
                }
            }
            $response['error'] = $error;
            $response['message'] = $message;
            $response['data'] = (!empty($data) ? $data : '');
            $response['csrfName'] = $this->security->get_csrf_token_name();
            $response['csrfHash'] = $this->security->get_csrf_hash();
            print_r(json_encode($response));
        } else {
            redirect('admin/login', 'refresh');
        }
    }

    public function edit_orders()
    {
        if ($this->ion_auth->logged_in() && $this->ion_auth->is_admin()) {

            if (!has_permissions('read', 'orders')) {
                $this->session->set_flashdata('authorize_flag', PERMISSION_ERROR_MSG);
                redirect('admin/home', 'refresh');
            }

            $bank_transfer = $order_tracking = $pickup_location = array();
            $this->data['main_page'] = FORMS . 'edit-orders';
            $settings = get_settings('system_settings', true);

            $this->data['title'] = 'View Order | ' . $settings['app_name'];
            $this->data['meta_description'] = 'View Order | ' . $settings['app_name'];
            $this->data['delivery_res'] = $this->db->where(['ug.group_id' => '3', 'u.active' => 1])->join('users_groups ug', 'ug.user_id = u.id')->get('users u')->result_array();

            $res = $this->Order_model->get_order_details(['o.id' => $_GET['edit_id']]);

            if ($res[0]['payment_method'] == "bank_transfer") {
                $bank_transfer = fetch_details('order_bank_transfer', ['order_id' => $res[0]['order_id']]);
            }
            $order_tracking = fetch_details('order_tracking', ['order_id' => $res[0]['order_id']], 'courier_agency,tracking_id,url');
            if (isset($_GET['edit_id']) && !empty($_GET['edit_id']) && !empty($res) && is_numeric($_GET['edit_id'])) {

                // check for notification param
                if (isset($_GET['noti_id']) && !empty($_GET['noti_id']) && is_numeric($_GET['noti_id'])) {
                    update_details(['read_by' => '1'], ['id' => $_GET['noti_id']], 'system_notification');
                }
                $items = [];

                foreach ($res as $row) {
                    $updated_username = fetch_details('users', 'id =' . $row['updated_by'], 'username');

                    $temp['id'] = $row['order_item_id'];
                    $temp['attachment'] = $row['attachment'];
                    $temp['product_id'] = $row['product_id'];
                    $temp['product_variant_id'] = $row['product_variant_id'];
                    $temp['product_type'] = $row['type'];
                    $temp['pname'] = $row['pname'];
                    $temp['download_allowed'] = $row['download_allowed'];
                    $temp['quantity'] = $row['quantity'];
                    $temp['is_cancelable'] = $row['is_cancelable'];
                    $temp['is_returnable'] = $row['is_returnable'];
                    $temp['tax_amount'] = $row['tax_amount'];
                    $temp['discounted_price'] = $row['discounted_price'];
                    $temp['price'] = $row['price'];
                    $temp['row_price'] = $row['row_price'];
                    $temp['active_status'] = $row['oi_active_status'];
                    $temp['product_image'] = $row['product_image'];
                    $temp['pickup_location'] = $row['pickup_location'];
                    $temp['sku'] = $row['sku'];
                    $temp['final_total'] = $row['final_total'];
                    $temp['product_variants'] = get_variants_values_by_id($row['product_variant_id']);
                    $temp['updated_by'] = $updated_username[0]['username'];
                    $temp['product_slug'] = $row['product_slug'];
                    $temp['is_sent'] = $row['is_sent'];
                    array_push($items, $temp);
                }

                $pickup_location = fetch_details('pickup_locations', ['status' => 1], 'id,pickup_location');

                $this->data['order_detls'] = $res;
                $this->data['bank_transfer'] = $bank_transfer;
                $this->data['order_tracking'] = $order_tracking;
                $this->data['items'] = $items;
                $this->data['pickup_location'] = $pickup_location;
                $this->data['settings'] = get_settings('system_settings', true);
                $this->data['shiprocket_settings'] = get_settings('shipping_method', true);
                $this->load->view('admin/template', $this->data);
            } else {
                redirect('admin/orders/', 'refresh');
            }
        } else {
            redirect('admin/login', 'refresh');
        }
    }

    /* Update individual order item status */
    public function update_order_status()
    {
        if ($this->ion_auth->logged_in() && $this->ion_auth->is_admin()) {
            if (print_msg(!has_permissions('update', 'orders'), PERMISSION_ERROR_MSG, 'orders')) {
                return false;
            }

            $res = validate_order_status(trim($_GET['id']), trim($_GET['status']));
            if ($res['error']) {
                $this->response['error'] = true;
                $this->response['message'] = $res['message'];
                $this->response['csrfName'] = $this->security->get_csrf_token_name();
                $this->response['csrfHash'] = $this->security->get_csrf_hash();
                $this->response['data'] = array();
                print_r(json_encode($this->response));
                return false;
            }

            $order_id = fetch_details('order_items', ['id' => trim($_GET['id'])], 'order_id');
            $order_method = fetch_details('orders', ['id' => $order_id[0]['order_id']], 'payment_method');
            if ($order_method[0]['payment_method'] == 'bank_transfer') {
                $bank_receipt = fetch_details('order_bank_transfer', ['order_id' => $order_id[0]['order_id']]);
                $transaction_status = fetch_details('transactions', ['order_id' => $order_id[0]['order_id']], 'status');
                if ($_GET['status'] != 'cancelled' && (empty($bank_receipt) || strtolower($transaction_status[0]['status']) != 'success' || $bank_receipt[0]['status'] == "0" || $bank_receipt[0]['status'] == "1")) {
                    $this->response['error'] = true;
                    $this->response['message'] = "Order Status can not update, Bank verification is remain from transactions.";
                    $this->response['csrfName'] = $this->security->get_csrf_token_name();
                    $this->response['csrfHash'] = $this->security->get_csrf_hash();
                    $this->response['data'] = array();
                    print_r(json_encode($this->response));
                    return false;
                }
            }

            $order_item_res = $this->db->select(' * , (Select count(id) from order_items where order_id = oi.order_id ) as order_counter ,(Select count(active_status) from order_items where active_status ="cancelled" and order_id = oi.order_id ) as order_cancel_counter , (Select count(active_status) from order_items where active_status ="returned" and order_id = oi.order_id ) as order_return_counter,(Select count(active_status) from order_items where active_status ="delivered" and order_id = oi.order_id ) as order_delivered_counter , (Select count(active_status) from order_items where active_status ="processed" and order_id = oi.order_id ) as order_processed_counter , (Select count(active_status) from order_items where active_status ="shipped" and order_id = oi.order_id ) as order_shipped_counter ,(Select count(active_status) from order_items where active_status ="ready_to_pickup" and order_id = oi.order_id ) as order_ready_to_pickup_counter, (Select status from orders where id = oi.order_id ) as order_status ')
                ->where(['id' => $_GET['id']])
                ->get('order_items oi')->result_array();

            $otp_system = $order_item_res[0]['deliveryboy_otp_setting_on'];
            if ($_POST['status'] == 'delivered') {
                if ($otp_system == 1) {

                    if (!validate_otp($order_item_res[0]['order_id'], otp: $_POST['otp'])) {
                        $this->response['error'] = true;
                        $this->response['message'] = 'Invalid OTP supplied!';
                        $this->response['csrfName'] = $this->security->get_csrf_token_name();
                        $this->response['csrfHash'] = $this->security->get_csrf_hash();
                        $this->response['data'] = array();
                        print_r(json_encode($this->response));
                        return false;
                    }
                }
            }

            if ($this->Order_model->update_order(['status' => $_GET['status']], ['id' => $order_item_res[0]['id']], true, 'order_items')) {
                $this->Order_model->update_order(['active_status' => $_GET['status']], ['id' => $order_item_res[0]['id']], false, 'order_items');
                process_refund($order_item_res[0]['id'], $_GET['status']);

                if (trim($_GET['status']) == 'cancelled' || trim($_GET['status']) == 'returned') {
                    $data = fetch_details('order_items', ['id' => $_GET['id']], 'product_variant_id,quantity');
                    update_stock($data[0]['product_variant_id'], $data[0]['quantity'], 'plus');
                }
                if (($order_item_res[0]['order_counter'] == intval($order_item_res[0]['order_cancel_counter']) + 1 && $_GET['status'] == 'cancelled') || ($order_item_res[0]['order_counter'] == intval($order_item_res[0]['order_return_counter']) + 1 && $_GET['status'] == 'returned') || ($order_item_res[0]['order_counter'] == intval($order_item_res[0]['order_delivered_counter']) + 1 && $_GET['status'] == 'delivered') || ($order_item_res[0]['order_counter'] == intval($order_item_res[0]['order_processed_counter']) + 1 && $_GET['status'] == 'processed') || ($order_item_res[0]['order_counter'] == intval($order_item_res[0]['order_shipped_counter']) + 1 && $_GET['status'] == 'shipped') || ($order_item_res[0]['order_counter'] == intval($order_item_res[0]['order_ready_to_pickup_counter']) + 1 && $_GET['status'] == 'ready_to_pickup')) {
                    if ($this->Order_model->update_order(['status' => $_GET['status']], ['id' => $order_item_res[0]['order_id']], true)) {
                        $this->Order_model->update_order(['active_status' => $_GET['status']], ['id' => $order_item_res[0]['order_id']]);
                        /* process the refer and earn */
                        $user = fetch_details('orders', ['id' => $order_item_res[0]['order_id']], 'user_id');
                        $user_id = $user[0]['user_id'];
                        $response = process_referral_bonus($user_id, $order_item_res[0]['order_id'], $_GET['status']);

                        $settings = get_settings('system_settings', true);
                        $app_name = isset($settings['app_name']) && !empty($settings['app_name']) ? $settings['app_name'] : '';

                        $user_res = fetch_details('users', ['id' => $user_id], 'username,fcm_id,mobile,email,web_fcm');

                        // Custom notification message
                        $type = [];
                        if ($_GET['status'] == 'received') {
                            $type = ['type' => "customer_order_received"];
                        } elseif ($_GET['status'] == 'processed') {
                            $type = ['type' => "customer_order_processed"];
                        } elseif ($_GET['status'] == 'shipped') {
                            $type = ['type' => "customer_order_shipped"];
                        } elseif ($_GET['status'] == 'delivered') {
                            $type = ['type' => "customer_order_delivered"];
                        } elseif ($_GET['status'] == 'cancelled') {
                            $type = ['type' => "customer_order_cancelled"];
                        } elseif ($_GET['status'] == 'returned') {
                            $type = ['type' => "customer_order_returned"];
                        }

                        $custom_notification = fetch_details('custom_notifications', $type, '');

                        $hashtag_customer_name = '< customer_name >';
                        $hashtag_order_id = '< order_id >';
                        $hashtag_application_name = '< application_name >';

                        $string = json_encode($custom_notification[0]['message'], JSON_UNESCAPED_UNICODE);
                        $hashtag = html_entity_decode($string);

                        $data = str_replace(array($hashtag_customer_name, $hashtag_order_id, $hashtag_application_name), array($user_res[0]['username'], $order_item_res[0]['id'], $app_name), $hashtag);
                        $message = output_escaping(trim($data, '"'));

                        $customer_msg = (!empty($custom_notification)) ? $message : 'Hello Dear ' . $user_res[0]['username'] . ' order status updated to ' . $_GET['status'] . ' for your order ID #' . $order_item_res[0]['id'] . ' please take note of it! Thank you for shopping with us. Regards ' . $app_name . '';

                        $fcm_ids = array();
                        $web_fcm = array();

                        if (!empty($user_res[0]['fcm_id']) || !empty($user_res[0]['web_fcm'])) {
                            $fcmMsg = array(
                                'title' => (!empty($custom_notification)) ? $custom_notification[0]['title'] : "Order status updated",
                                'body' => $customer_msg,
                                'type' => "order"
                            );

                            if (!empty($user_res[0]['fcm_id'])) {
                                $fcm_ids[0][] = $user_res[0]['fcm_id'];
                                send_notification($fcmMsg, $fcm_ids, $fcmMsg);
                            }

                            if (!empty($user_res[0]['web_fcm'])) {
                                $web_fcm[0][] = $user_res[0]['web_fcm'];
                                send_notification_for_web($fcmMsg, $web_fcm, $fcmMsg);
                            }
                        }

                        notify_event(
                            $type['type'],
                            ["delivery_boy" => [$user_res[0]['email']]],
                            ["delivery_boy" => [$user_res[0]['mobile']]],
                            ["orders.id" => $order_item_res[0]['id']]
                        );
                    }
                }

                // Update login id in order_item table
                update_details(['updated_by' => $_SESSION['user_id']], ['id' => $_GET['id']], 'order_items');

                $this->response['error'] = false;
                $this->response['message'] = 'Status Updated Successfully';
                $this->response['csrfName'] = $this->security->get_csrf_token_name();
                $this->response['csrfHash'] = $this->security->get_csrf_hash();
                $this->response['data'] = array();
                print_r(json_encode($this->response));
                return false;
            }
        } else {
            $this->response['error'] = true;
            $this->response['message'] = 'Unauthorized access not allowed!';
            $this->response['csrfName'] = $this->security->get_csrf_token_name();
            $this->response['csrfHash'] = $this->security->get_csrf_hash();
            $this->response['data'] = array();
            print_r(json_encode($this->response));
            return false;
        }
    }
    public function update_mail_status()
    {
        if ($this->ion_auth->logged_in() && $this->ion_auth->is_admin()) {

            if (update_details(['is_sent' => 1], ['id' => $_GET['id']], 'order_items')) {
                $this->response['error'] = false;
                $this->response['message'] = 'Mail status updated successfully!';
                $this->response['csrfName'] = $this->security->get_csrf_token_name();
                $this->response['csrfHash'] = $this->security->get_csrf_hash();
                $this->response['data'] = array();
                print_r(json_encode($this->response));
                return false;
            }
        } else {
            $this->response['error'] = true;
            $this->response['message'] = 'Unauthorized access not allowed!';
            $this->response['csrfName'] = $this->security->get_csrf_token_name();
            $this->response['csrfHash'] = $this->security->get_csrf_hash();
            $this->response['data'] = array();
            print_r(json_encode($this->response));
            return false;
        }
    }
    // delete_receipt
    function delete_receipt()
    {
        if ($this->ion_auth->logged_in() && $this->ion_auth->is_admin()) {

            if (empty($_GET['id'])) {
                $response['error'] = true;
                $response['message'] = 'Something went wrong';
            }
            if (delete_details(['id' => $_GET['id']], "order_bank_transfer")) {
                $response['error'] = false;
                $response['message'] = 'Deleted Successfully';
            } else {
                $response['error'] = true;
                $response['message'] = 'Something went wrong';
            }
            echo json_encode($response);
        } else {
            redirect('admin/login', 'refresh');
        }
    }
    function update_receipt_status()
    {
        if ($this->ion_auth->logged_in() && $this->ion_auth->is_admin()) {

            $this->form_validation->set_rules('order_id', 'Order Id', 'trim|required|xss_clean');
            $this->form_validation->set_rules('user_id', 'User Id', 'trim|required|xss_clean');
            $this->form_validation->set_rules('status', 'status', 'trim|required|xss_clean');

            if (!$this->form_validation->run()) {

                $this->response['error'] = true;
                $this->response['csrfName'] = $this->security->get_csrf_token_name();
                $this->response['csrfHash'] = $this->security->get_csrf_hash();
                $this->response['message'] = validation_errors();
                print_r(json_encode($this->response));
                return false;
            } else {
                $order_id = $this->input->post('order_id', true);
                $user_id = $this->input->post('user_id', true);
                $status = $this->input->post('status', true);
                $rcpt_status = fetch_details("order_bank_transfer", ['order_id' => $order_id], "status");
                if ($rcpt_status[0]['status'] == 2) {
                    $this->response['error'] = true;
                    $this->response['message'] = 'Already accepted the bank receipt';
                    $this->response['csrfName'] = $this->security->get_csrf_token_name();
                    $this->response['csrfHash'] = $this->security->get_csrf_hash();
                    print_r(json_encode($this->response));
                    return false;
                }

                if (update_details(['status' => $status], ['order_id' => $order_id], 'order_bank_transfer')) {
                    if ($status == 1) {
                        $status = "Rejected";
                    } else if ($status == 2) {
                        $status = "Accepted";

                        update_details(['active_status' => 'received'], ['id' => $order_id], 'orders');
                        update_details(['active_status' => 'received'], ['order_id' => $order_id], 'order_items');
                        $status = json_encode(array(array('received', date("d-m-Y h:i:sa"))));
                        update_details(['status' => $status], ['order_id' => $order_id], 'order_items', false);
                        update_details(['status' => $status], ['id' => $order_id], 'orders', false);
                    } else {
                        $status = "Pending";
                    }

                    //custom notification message
                    $custom_notification = fetch_details('custom_notifications', ['type' => "bank_transfer_receipt_status"], '');

                    $hashtag_status = '< status >';
                    $hashtag_order_id = '< order_id >';

                    $string = json_encode($custom_notification[0]['message'], JSON_UNESCAPED_UNICODE);
                    $hashtag = html_entity_decode($string);

                    $data = str_replace(array($hashtag_status, $hashtag_order_id), array($status, $order_id), $hashtag);
                    $message = output_escaping(trim($data, '"'));

                    $customer_title = (!empty($custom_notification)) ? $custom_notification[0]['title'] : 'Bank Transfer Receipt Status';
                    $customer_msg = (!empty($custom_notification)) ? $message : 'Bank Transfer Receipt ' . $status . ' for order ID: ' . $order_id;

                    $user = fetch_details("users", ['id' => $user_id], 'email,fcm_id,web_fcm');

                    // Send email
                    send_mail($user[0]['email'], 'Bank Transfer Receipt Status.', 'Bank Transfer Receipt ' . $status . ' for order ID: ' . $order_id);

                    // Prepare FCM IDs
                    $fcm_ids = array();
                    $web_fcm = array();

                    if (!empty($user[0]['fcm_id'])) {
                        $fcm_ids[0][] = $user[0]['fcm_id'];
                    }

                    if (!empty($user[0]['web_fcm'])) {
                        $web_fcm[0][] = $user[0]['web_fcm'];
                    }

                    // Send notifications
                    if (!empty($fcm_ids) || !empty($web_fcm)) {
                        $fcmMsg = array(
                            'title' => $customer_title,
                            'body' => $customer_msg,
                            'type' => "order"
                        );

                        if (!empty($fcm_ids)) {
                            send_notification($fcmMsg, $fcm_ids, $fcmMsg);
                        }

                        if (!empty($web_fcm)) {
                            send_notification_for_web($fcmMsg, $web_fcm, $fcmMsg);
                        }
                    }

                    $this->response['error'] = false;
                    $this->response['message'] = 'Updated Successfully';
                    $this->response['csrfName'] = $this->security->get_csrf_token_name();
                    $this->response['csrfHash'] = $this->security->get_csrf_hash();
                } else {
                    $this->response['error'] = true;
                    $this->response['message'] = 'Something went wrong';
                    $this->response['csrfName'] = $this->security->get_csrf_token_name();
                    $this->response['csrfHash'] = $this->security->get_csrf_hash();
                }
            }

            print_r(json_encode($this->response));
        } else {
            redirect('admin/login', 'refresh');
        }
    }

    function order_tracking()
    {
        if ($this->ion_auth->logged_in() && $this->ion_auth->is_admin()) {
            $this->data['main_page'] = TABLES . 'order-tracking';
            $settings = get_settings('system_settings', true);
            $this->data['title'] = 'Order Tracking | ' . $settings['app_name'];
            $this->data['meta_description'] = 'Order Tracking | ' . $settings['app_name'];
            $this->load->view('admin/template', $this->data);
        } else {
            redirect('admin/login', 'refresh');
        }
    }

    public function get_order_tracking()
    {
        if ($this->ion_auth->logged_in() && $this->ion_auth->is_admin()) {
            return $this->Order_model->get_order_tracking_list();
        } else {
            redirect('admin/login', 'refresh');
        }
    }
    public function valid_url($url)
    {
        if (filter_var($url, FILTER_VALIDATE_URL) === FALSE) {
            $this->form_validation->set_message('valid_url', 'The {field} field must contain a valid URL.');
            return FALSE;
        }

        // Regex to check for specific TLDs
        $pattern = '/\.(com|in|net|org|gov|edu|mil|aspx)$/i';
        if (preg_match($pattern, $url) === 0) {
            $this->form_validation->set_message('valid_url', 'The {field} field must contain a URL ending with .com, .in, .net, .org, .gov, .edu,.aspx or .mil.');
            return FALSE;
        }

        return TRUE;
    }
    public function update_order_tracking()
    {
        if (has_permissions('update', 'orders') == false) {
            $this->response['error'] = true;
            $this->response['csrfName'] = $this->security->get_csrf_token_name();
            $this->response['csrfHash'] = $this->security->get_csrf_hash();
            $this->response['message'] = PERMISSION_ERROR_MSG;
            print_r(json_encode($this->response));
            return false;
        }

        if ($this->ion_auth->logged_in() && $this->ion_auth->is_admin()) {
            $this->form_validation->set_rules('courier_agency', 'Courier Agency', 'trim|required|xss_clean');
            $this->form_validation->set_rules('tracking_id', 'Tracking Id', 'trim|required|xss_clean');
            $this->form_validation->set_rules('url', 'URL', 'trim|required|xss_clean|callback_valid_url');
            $this->form_validation->set_rules('order_id', 'order_id', 'trim|required|xss_clean');
            if (!$this->form_validation->run()) {
                $this->response['error'] = true;
                $this->response['csrfName'] = $this->security->get_csrf_token_name();
                $this->response['csrfHash'] = $this->security->get_csrf_hash();
                $this->response['message'] = validation_errors();
                print_r(json_encode($this->response));
            } else {
                $order_id = $this->input->post('order_id', true);
                $courier_agency = $this->input->post('courier_agency', true);
                $tracking_id = $this->input->post('tracking_id', true);
                $url = $this->input->post('url', true);
                $data = array(
                    'order_id' => $order_id,
                    'courier_agency' => $courier_agency,
                    'tracking_id' => $tracking_id,
                    'url' => $url,
                );
                if (is_exist(['order_id' => $order_id], 'order_tracking', null)) {
                    if (update_details($data, ['order_id' => $order_id], 'order_tracking') == TRUE) {
                        $this->response['error'] = false;
                        $this->response['csrfName'] = $this->security->get_csrf_token_name();
                        $this->response['csrfHash'] = $this->security->get_csrf_hash();
                        $this->response['message'] = "Order Tracking Update Successfuly.";
                    } else {
                        $this->response['error'] = true;
                        $this->response['csrfName'] = $this->security->get_csrf_token_name();
                        $this->response['csrfHash'] = $this->security->get_csrf_hash();
                        $this->response['message'] = "Not Updated. Try again later.";
                    }
                } else {
                    if (insert_details($data, 'order_tracking')) {
                        $this->response['error'] = false;
                        $this->response['csrfName'] = $this->security->get_csrf_token_name();
                        $this->response['csrfHash'] = $this->security->get_csrf_hash();
                        $this->response['message'] = "Order Tracking Added Successfuly.";
                    } else {
                        $this->response['error'] = true;
                        $this->response['csrfName'] = $this->security->get_csrf_token_name();
                        $this->response['csrfHash'] = $this->security->get_csrf_hash();
                        $this->response['message'] = "Not Added. Try again later.";
                    }
                }
                print_r(json_encode($this->response));
            }
        } else {
            redirect('admin/login', 'refresh');
        }
    }

    public function refund_payment()
    {
        if ($this->ion_auth->logged_in() && $this->ion_auth->is_admin()) {
            $this->form_validation->set_rules('txn_id', 'Transaction Id', 'trim|required|xss_clean');
            $this->form_validation->set_rules('txn_amount', 'Transaction Amount', 'trim|required|xss_clean');

            if (!$this->form_validation->run()) {
                $this->response['error'] = true;
                $this->response['csrfName'] = $this->security->get_csrf_token_name();
                $this->response['csrfHash'] = $this->security->get_csrf_hash();
                $this->response['message'] = validation_errors();
                print_r(json_encode($this->response));
            } else {
                $txn_id = $this->input->post('txn_id', true);
                $amount = $this->input->post('amount', true);
                if (!empty($this->input->post()) || (isset($txn_id) && $txn_id != '') && (isset($amount) && $amount != '')) {
                    $item_id = trim($this->input->post('item_id', true));
                    $payment_method = $this->input->post('refund_payment_method', true);
                    $txn_id = $this->input->post('txn_id', true);
                    $amount = $this->input->post('txn_amount', true);

                    if ($payment_method == 'Razorpay') {
                        // razorpay payment refund
                        $payment = $this->razorpay->refund_payment($txn_id, $amount);
                        if (([$payment['http_code']] != 'null') && empty($payment['http_code']) && $payment['http_code'] != '400') {
                            update_details(['is_refund' => 1], ['order_item_id' => $item_id], 'transactions');
                            $this->response['error'] = false;
                            $this->response['csrfName'] = $this->security->get_csrf_token_name();
                            $this->response['csrfHash'] = $this->security->get_csrf_hash();
                            $this->response['message'] = "Payment Refund Successfully";
                        } else {
                            $message = json_decode($payment['body'], true);
                            $this->response['error'] = true;
                            $this->response['csrfName'] = $this->security->get_csrf_token_name();
                            $this->response['csrfHash'] = $this->security->get_csrf_hash();
                            $this->response['message'] = $message['error']['description'];
                        }
                    } else if ($payment_method == 'Flutterwave') {
                        // flutterwave payment refund
                        $payment = $this->flutterwave->refund_payment($txn_id, $amount);
                        if ($payment['status'] == 'success') {
                            update_details(['is_refund' => 1], ['order_item_id' => $item_id], 'transactions');
                            $this->response['error'] = false;
                            $this->response['csrfName'] = $this->security->get_csrf_token_name();
                            $this->response['csrfHash'] = $this->security->get_csrf_hash();
                            $this->response['message'] = "Payment Refund Successfully";
                        } else {
                            $message = json_decode($payment, true);
                            $this->response['error'] = true;
                            $this->response['csrfName'] = $this->security->get_csrf_token_name();
                            $this->response['csrfHash'] = $this->security->get_csrf_hash();
                            $this->response['message'] = $message['message'];
                        }
                    } else if ($payment_method == 'Paystack') {
                        // Paystack payment refund
                        $payment = $this->paystack->refund_payment($txn_id, $amount);
                        $message = json_decode($payment, true);
                        if ($payment['status'] == 'true') {
                            update_details(['is_refund' => 1], ['order_item_id' => $item_id], 'transactions');
                            $this->response['error'] = false;
                            $this->response['csrfName'] = $this->security->get_csrf_token_name();
                            $this->response['csrfHash'] = $this->security->get_csrf_hash();
                            $this->response['message'] = $message['message'];
                        } else {
                            $this->response['error'] = false;
                            $this->response['csrfName'] = $this->security->get_csrf_token_name();
                            $this->response['csrfHash'] = $this->security->get_csrf_hash();
                            $this->response['message'] = $message['message'];
                        }
                    }
                    print_r(json_encode($this->response));
                }
            }
        } else {
            redirect('admin/login', 'refresh');
        }
    }

    // Shiprocket order process   

    public function generate_awb()
    {
        if ($this->ion_auth->logged_in() && $this->ion_auth->is_admin()) {

            $order_tracking = fetch_details('order_tracking', ['shipment_id' => $this->input->post('shipment_id', true)], 'courier_company_id');
            $courier_company_id = $order_tracking[0]['courier_company_id'];

            $this->load->library(['Shiprocket']);
            $res = $this->shiprocket->generate_awb($this->input->post('shipment_id', true));
            if (isset($res['awb_assign_status']) && $res['awb_assign_status'] == 1) {
                $order_tracking_data = [
                    'awb_code' => $res['response']['data']['awb_code'],
                ];
                $res_shippment_data = $this->shiprocket->get_order($this->input->post('shipment_id', true));
                $this->db->set($order_tracking_data)->where('shipment_id', $this->input->post('shipment_id', true))->update('order_tracking');
            } else {
                $res = $this->shiprocket->generate_awb($this->input->post('shipment_id', true));
                $order_tracking_data = [
                    'awb_code' => $res['response']['data']['awb_code'],
                ];
                $res_shippment_data = $this->shiprocket->get_order($this->input->post('shipment_id', true));
                $this->db->set($order_tracking_data)->where('shipment_id', $this->input->post('shipment_id', true))->update('order_tracking');
            }
            if (!empty($res)) {
                $this->response['error'] = false;
                $this->response['csrfName'] = $this->security->get_csrf_token_name();
                $this->response['csrfHash'] = $this->security->get_csrf_hash();
                $this->response['message'] = 'AWB generated successfully';
                $this->response['data'] = $res;
            } else {
                $this->response['error'] = true;
                $this->response['csrfName'] = $this->security->get_csrf_token_name();
                $this->response['csrfHash'] = $this->security->get_csrf_hash();
                $this->response['message'] = 'AWB not generated';
                $this->response['data'] = array();
            }
            print_r(json_encode($this->response));
        } else {
            redirect('admin/login', 'refresh');
        }
    }

    public function send_pickup_request()
    {
        if ($this->ion_auth->logged_in() && $this->ion_auth->is_admin()) {


            $this->load->library(['Shiprocket']);
            $res = $this->shiprocket->request_for_pickup($this->input->post('shipment_id', true));


            if (isset($res['pickup_status']) && $res['pickup_status'] == 1) {

                $order_tracking_data = [
                    'pickup_status' => $res['pickup_status'],
                    'pickup_scheduled_date' => $res['response']['pickup_scheduled_date'],
                    'pickup_token_number' => $res['response']['pickup_token_number'],
                    'status' => $res['response']['status'],
                    'pickup_generated_date' => json_encode(array($res['response']['pickup_generated_date'])),
                    'data' => $res['response']['data'],
                ];
                $this->db->set($order_tracking_data)->where('shipment_id', $this->input->post('shipment_id', true))->update('order_tracking');
            }
            if (!empty($res)) {
                $this->response['error'] = false;
                $this->response['csrfName'] = $this->security->get_csrf_token_name();
                $this->response['csrfHash'] = $this->security->get_csrf_hash();
                $this->response['message'] = 'Request send successfully';
                $this->response['data'] = $res;
            } else {
                $this->response['error'] = true;
                $this->response['csrfName'] = $this->security->get_csrf_token_name();
                $this->response['csrfHash'] = $this->security->get_csrf_hash();
                $this->response['message'] = 'Request not sent';
                $this->response['data'] = array();
            }
            print_r(json_encode($this->response));
        } else {
            redirect('admin/login', 'refresh');
        }
    }

    public function generate_menifest()
    {
        if ($this->ion_auth->logged_in() && $this->ion_auth->is_admin()) {
            $this->load->library(['Shiprocket']);
            $res = $this->shiprocket->generate_manifests($this->input->post('shipment_id', true));

            if (isset($res['status']) && $res['status'] == 1) {
                $manifest_data = [
                    'manifest_url' => $res['manifest_url'],
                ];
                $this->db->set($manifest_data)->where('shipment_id', $this->input->post('shipment_id', true))->update('order_tracking');
            }

            if (!empty($res)) {
                $this->response['error'] = false;
                $this->response['csrfName'] = $this->security->get_csrf_token_name();
                $this->response['csrfHash'] = $this->security->get_csrf_hash();
                $this->response['message'] = 'Manifest generated successfully';
                $this->response['data'] = $res;
            } else {
                $this->response['error'] = true;
                $this->response['csrfName'] = $this->security->get_csrf_token_name();
                $this->response['csrfHash'] = $this->security->get_csrf_hash();
                $this->response['message'] = 'Manifest not generated';
                $this->response['data'] = array();
            }
            print_r(json_encode($this->response));
        } else {
            redirect('admin/login', 'refresh');
        }
    }

    public function generate_label()
    {
        if ($this->ion_auth->logged_in() && $this->ion_auth->is_admin()) {
            $this->load->library(['Shiprocket']);
            $res = $this->shiprocket->generate_label($this->input->post('shipment_id', true));

            if (isset($res['label_created']) && $res['label_created'] == 1) {
                $label_data = [
                    'label_url' => $res['label_url'],
                ];
                $this->db->set($label_data)->where('shipment_id', $this->input->post('shipment_id', true))->update('order_tracking');
            }
            if (!empty($res)) {
                $this->response['error'] = false;
                $this->response['csrfName'] = $this->security->get_csrf_token_name();
                $this->response['csrfHash'] = $this->security->get_csrf_hash();
                $this->response['message'] = 'Label generated successfully';
                $this->response['data'] = $res;
            } else {
                $this->response['error'] = true;
                $this->response['csrfName'] = $this->security->get_csrf_token_name();
                $this->response['csrfHash'] = $this->security->get_csrf_hash();
                $this->response['message'] = 'Label not generated';
                $this->response['data'] = array();
            }
            print_r(json_encode($this->response));
        } else {
            redirect('admin/login', 'refresh');
        }
    }
    public function generate_invoice()
    {
        if ($this->ion_auth->logged_in() && $this->ion_auth->is_admin()) {
            $this->load->library(['Shiprocket']);
            $res = $this->shiprocket->generate_invoice($this->input->post('order_id', true));

            if (isset($res['is_invoice_created']) && $res['is_invoice_created'] == 1) {
                $invoice_data = [
                    'invoice_url' => $res['invoice_url'],
                ];
                $this->db->set($invoice_data)->where('shiprocket_order_id', $this->input->post('order_id', true))->update('order_tracking');
            }
            if (!empty($res)) {
                $this->response['error'] = false;
                $this->response['csrfName'] = $this->security->get_csrf_token_name();
                $this->response['csrfHash'] = $this->security->get_csrf_hash();
                $this->response['message'] = 'Invoice generated successfully';
                $this->response['data'] = $res;
            } else {
                $this->response['error'] = true;
                $this->response['csrfName'] = $this->security->get_csrf_token_name();
                $this->response['csrfHash'] = $this->security->get_csrf_hash();
                $this->response['message'] = 'Invoice not generated';
                $this->response['data'] = array();
            }
            print_r(json_encode($this->response));
        } else {
            redirect('admin/login', 'refresh');
        }
    }

    public function cancel_shiprocket_order()
    {
        if ($this->ion_auth->logged_in() && $this->ion_auth->is_admin()) {
            $this->load->library(['Shiprocket']);
            $res = $this->shiprocket->cancel_order($this->input->post('shiprocket_order_id', true));
            $is_canceled = [
                'is_canceled' => 1,
            ];
            $this->db->set($is_canceled)->where('shiprocket_order_id', $this->input->post('shiprocket_order_id', true))->update('order_tracking');
            if (!empty($res) && $res['status'] == 200) {
                $this->response['error'] = false;
                $this->response['csrfName'] = $this->security->get_csrf_token_name();
                $this->response['csrfHash'] = $this->security->get_csrf_hash();
                $this->response['message'] = 'Order cancelled successfully';
                $this->response['data'] = $res;
            } else {
                $this->response['error'] = true;
                $this->response['csrfName'] = $this->security->get_csrf_token_name();
                $this->response['csrfHash'] = $this->security->get_csrf_hash();
                $this->response['message'] = 'Order not cancelled';
                $this->response['data'] = array();
            }
            print_r(json_encode($this->response));
        } else {
            redirect('admin/login', 'refresh');
        }
    }


    public function create_shiprocket_order()
    {
        if ($this->ion_auth->logged_in() && $this->ion_auth->is_admin()) {

            $this->form_validation->set_rules('pickup_location', ' Pickup Location ', 'trim|required|xss_clean');
            $this->form_validation->set_rules('parcel_weight', ' Parcel Weight ', 'trim|required|xss_clean');
            $this->form_validation->set_rules('parcel_height', ' Parcel Height ', 'trim|required|xss_clean');
            $this->form_validation->set_rules('parcel_breadth', ' Parcel Breadth ', 'trim|required|xss_clean');
            $this->form_validation->set_rules('parcel_length', ' Parcel Length ', 'trim|required|xss_clean');

            if (!$this->form_validation->run()) {
                $this->response['error'] = true;
                $this->response['csrfName'] = $this->security->get_csrf_token_name();
                $this->response['csrfHash'] = $this->security->get_csrf_hash();
                $this->response['message'] = validation_errors();
                print_r(json_encode($this->response));
            } else {
                $_POST['order_items'] = json_decode($this->input->post('order_items', true)[0], 1);

                $this->load->library(['Shiprocket']);

                $order_items = $this->input->post('order_items', true);
                $items = [];
                $subtotal = 0;
                $order_id = 0;



                $pickup_location_pincode = fetch_details('pickup_locations', ['pickup_location' => $this->input->post('pickup_location', true)], 'pin_code');
                $user_data = fetch_details('users', ['id' => $this->input->post('user_id', true)], 'username,email');
                $order_data = fetch_details('orders', ['id' => $this->input->post('order_id', true)], 'date_added,address_id,mobile,payment_method');
                $address_data = fetch_details('addresses', ['id' => $order_data[0]['address_id']], 'address,city_id,pincode,state,country');
                $city_data = fetch_details('cities', ['id' => $address_data[0]['city_id']], 'name');

                $availibility_data = [
                    'pickup_postcode' => $pickup_location_pincode[0]['pin_code'],
                    'delivery_postcode' => $address_data[0]['pincode'],
                    'cod' => ($order_data[0]['payment_method'] == 'COD') ? '1' : '0',
                    'weight' => $this->input->post('parcel_weight', true),
                ];

                $check_deliveribility = $this->shiprocket->check_serviceability($availibility_data);
                $get_currier_id = shiprocket_recomended_data($check_deliveribility);

                foreach ($order_items as $row) {
                    if ($row['pickup_location'] == $this->input->post('pickup_location', true)) {
                        $order_item_id[] = $row['id'];
                        $order_id .= '-' . $row['id'];
                        $order_item_data = fetch_details('order_items', ['id' => $row['id']], 'sub_total');
                        $subtotal += $order_item_data[0]['sub_total'];
                        if (isset($row['product_variants']) && !empty($row['product_variants'])) {
                            $sku = $row['product_variants'][0]['sku'];
                        } else {
                            $sku = $row['sku'];
                        }
                        $temp['name'] = $row['pname'];
                        $temp['sku'] = isset($sku) && !empty($sku) ? $sku : substr($row['product_slug'], 0, 5);
                        $temp['units'] = $row['quantity'];
                        $temp['selling_price'] = $row['price'];
                        $temp['discount'] = $row['discounted_price'];
                        $temp['tax'] = $row['tax_amount'];
                        array_push($items, $temp);
                    }
                }
                $order_item_ids = implode(",", $order_item_id);
                $random_id = '-' . rand(10, 10000);
                $create_order = [
                    'order_id' => $this->input->post('order_id', true) . $order_id . $random_id,
                    'order_date' => $order_data[0]['date_added'],
                    'pickup_location' => $this->input->post('pickup_location', true),
                    'billing_customer_name' => $user_data[0]['username'],
                    'billing_last_name' => "",
                    'billing_address' => $address_data[0]['address'],
                    'billing_city' => $city_data[0]['name'],
                    'billing_pincode' => $address_data[0]['pincode'],
                    'billing_state' => $address_data[0]['state'],
                    'billing_country' => $address_data[0]['country'],
                    'billing_email' => $user_data[0]['email'],
                    'billing_phone' => $order_data[0]['mobile'],
                    'shipping_is_billing' => true,
                    'order_items' => $items,
                    'payment_method' => (strtoupper($order_data[0]['payment_method']) == 'COD') ? 'COD' : 'Prepaid',
                    'sub_total' => $subtotal,
                    'length' => $this->input->post('parcel_length', true),
                    'breadth' => $this->input->post('parcel_breadth', true),
                    'height' => $this->input->post('parcel_height', true),
                    'weight' => $this->input->post('parcel_weight', true),
                ];
                $response = $this->shiprocket->create_order($create_order);



                if (isset($response['status_code']) && $response['status_code'] == 1) {
                    $courier_company_id = $get_currier_id['courier_company_id'];
                    $order_tracking_data = [
                        'order_id' => $this->input->post('order_id', true),
                        'order_item_id' => $order_item_ids,
                        'shiprocket_order_id' => $response['order_id'],
                        'shipment_id' => $response['shipment_id'],
                        'courier_company_id' => $courier_company_id,
                        'pickup_status' => 0,
                        'pickup_scheduled_date' => '',
                        'pickup_token_number' => '',
                        'status' => 0,
                        'others' => '',
                        'pickup_generated_date' => '',
                        'data' => '',
                        'date' => '',
                        'manifest_url' => '',
                        'label_url' => '',
                        'invoice_url' => '',
                        'is_canceled' => 0,
                        'tracking_id' => '',
                        'url' => ''
                    ];
                    $this->db->insert('order_tracking', $order_tracking_data);
                }
                if (isset($response['status_code']) && $response['status_code'] == 1) {
                    $this->response['error'] = false;
                    $this->response['csrfName'] = $this->security->get_csrf_token_name();
                    $this->response['csrfHash'] = $this->security->get_csrf_hash();
                    $this->response['message'] = 'Shiprocket order created successfully';
                    $this->response['data'] = $response;
                } else {
                    $this->response['error'] = true;
                    $this->response['csrfName'] = $this->security->get_csrf_token_name();
                    $this->response['csrfHash'] = $this->security->get_csrf_hash();
                    $this->response['message'] = 'Shiprocket order not created successfully';
                    $this->response['data'] = $response;
                }
                print_r(json_encode($this->response));
            }
        } else {
            redirect('admin/login', 'refresh');
        }
    }
}
